<?php

namespace GestionBundle\Controller;

use GestionBundle\Entity\Composant;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use GestionBundle\Form\ComposantType;

/**
 * Composant controller.
 *
 */
class ResponsableComposantController extends Controller
{
    /**
     * Lists all composant entities.
     *
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $composants = $em->getRepository('GestionBundle:Composant')->findAll();

        return $this->render('GestionBundle:ResponsableComposant:index.html.twig', array(
            'composants' => $composants,
        ));
    }

    /**
     * Creates a new composant entity.
     *
     */
    public function newAction(Request $request)
    {
        $composant = new Composant();
        $form = $this->createForm(new ComposantType(), $composant);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($composant);
            $em->flush($composant);

            return $this->redirectToRoute('responsable_composant_show', array('id' => $composant->getId()));
        }

        return $this->render('GestionBundle:ResponsableComposant:new.html.twig', array(
            'composant' => $composant,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a composant entity.
     *
     */
    public function showAction(Composant $composant)
    {
        $deleteForm = $this->createDeleteForm($composant);
        $em = $this->getDoctrine()->getManager();
        $versions = $em->getRepository('GestionBundle:Version')->getAllVersionByComposant($composant->getId());

        return $this->render('GestionBundle:ResponsableComposant:show.html.twig', array(
            'composant' => $composant,
            'versions'  => $versions,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing composant entity.
     *
     */
    public function editAction(Request $request, Composant $composant)
    {
        $deleteForm = $this->createDeleteForm($composant);
        $editForm = $this->createForm(new ComposantType(), $composant);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('responsable_composant_show', array('id' => $composant->getId()));
        }

        return $this->render('GestionBundle:ResponsableComposant:edit.html.twig', array(
            'composant' => $composant,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a composant entity.
     *
     */
    public function deleteAction(Request $request, Composant $composant)
    {
        $form = $this->createDeleteForm($composant);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($composant);
            $em->flush($composant);
        }

        return $this->redirectToRoute('responsable_composant_index');
    }

    /**
     * Creates a form to delete a composant entity.
     *
     * @param Composant $composant The composant entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Composant $composant)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('responsable_composant_delete', array('id' => $composant->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
