<?php

namespace Repositories;

use Doctrine\ORM\EntityRepository;

/**
 * SessionRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class SessionRepository extends EntityRepository
{
      /**
     * Destroys client session
     * 
     * @param string $session_id
     */
    public function destroyAllBut($session_id) {
        $em = $this->getEntityManager();
        $qb = $this->createQueryBuilder('s')
                ->select('s')
                ->where('s.session_id != :session_id')
                ->setParameter('session_id', $session_id);
        $sessions = $qb->getQuery()->getResult();
        foreach ($sessions as $session) {
            $em->remove($session);
        }
        $em->flush();
    }
}