<?php

namespace Repositories;

use Doctrine\ORM\EntityRepository;

/**
 * ServiceRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ServiceRepository extends EntityRepository
{
    public function get() {
        $qb = $this->createQueryBuilder('s')
                ->select('s')
                ->orderBy('s.pos', 'ASC');
        $socials = $qb->getQuery()->getArrayResult();
        return $socials;
    }
    
    public function getById($id) {
        $qb = $this->createQueryBuilder('s')
                ->select('s')
                ->where('s.id = :id')
                ->setParameter('id', $id);
        $socials = $qb->getQuery()->getArrayResult();
        return $socials[0];
    }
    
    public function addService($service) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le service a été ajouté avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = new \Entities\Service();
            $entity->setTitle($service['title']);
            $entity->setDescription($service['description']);
            $entity->setClass($service['class']);
            $entity->setPos($service['pos']);

            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    public function update($id, $service) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le service a été modifiée avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = $this->find($id);

            $entity->setTitle($service['title']);
            $entity->setDescription($service['description']);
            $entity->setClass($service['class']);
            $entity->setPos($service['pos']);
            
            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    
    public function delete($id, $name) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le service ' . $name . ' a été supprimé avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $em->remove($this->find($id));
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    
    /**
     * Create social
     * 
     * @param array $social
     */
    protected function add($service) {
        $em = $this->getEntityManager();
        $entity = new \Entities\Service();
        
        $entity->setTitle($service['title']);
        $entity->setDescription($service['description']);
        $entity->setClass($service['class']);
        $entity->setPos($service['pos']);

        $em->persist($entity);
        $em->flush();
    }
    
    public function dumpService() {
        $socials = [
            [
                'title' => 'Développement web',
                'description'  => 'Développer des sites et des applications ou des modules web sur mesure et adaptées à vos besoins avec une qualité garantie.',
                'class'  => '<i class="fa fa-laptop"></i>',
                'pos'   => 1
            ],
            [
                'title' => 'Référencement',
                'description'  => 'Référencer et positionner vos sites Web pour moteurs de recherche en optimisant son référencement naturel.',
                'class'  => '<i class="fa fa-bar-chart"></i>',
                'pos'   => 2
            ],
            [
                'title' => 'Web Design',
                'description'  => 'Gérer la conception complète à partir de zéro afin d’étudier vos besoins et vos projets en design.',
                'class'  => '<i class="fa fa-pencil"></i>',
                'pos'   => 3
            ],
            [
                'title' => 'Photographie',
                'description'  => 'Pour renouveler mon imaginaire et ma créativité, je me déplace au monde de photographie.',
                'class'  => '<i class="fa fa-camera-retro"></i>',
                'pos'   => 4
            ],
            [
                'title' => 'Développement Mobile',
                'description'  => 'Ne perdez plus vos visiteurs mobiles ! Quelques lignes de codes peuvent tout changer ! Ne passez plus à côté.',
                'class'  => '<i class="fa fa-apple"></i>',
                'pos'   => 5
            ],
            [
                'title' => 'Support',
                'description'  => 'Support et accompagnement à votre service pour assurer le maintien en condition opérationnelle de votre solution.',
                'class'  => '<i class="fa fa-support"></i>',
                'pos'   => 6
            ]
        ];
        
        foreach($socials as $social) {
            $this->add($social);
        }
    }
}