<?php

namespace Repositories;

use Doctrine\ORM\EntityRepository;

/**
 * ProjectRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ProjectRepository extends EntityRepository
{
    public function get() {
        $qb = $this->createQueryBuilder('s')
                ->select('s, r')
                ->leftJoin('s.resource', 'r')
                ->orderBy('s.position', 'ASC');
        $slider = $qb->getQuery()->getArrayResult();
        return $slider;
    }
    
    public function getActive() {
        $qb = $this->createQueryBuilder('s')
                ->select('s, r')
                ->leftJoin('s.resource', 'r')
                ->where('s.active = 1')
                ->orderBy('s.position', 'ASC');
        $slider = $qb->getQuery()->getArrayResult();
        return $slider;
    }
    
    public function getById($id) {
        $qb = $this->createQueryBuilder('s')
                ->select('s,res')
                ->leftJoin('s.resource', 'res')
                ->where('s.id = :id')
                ->setParameter('id', $id);
        $sliders = $qb->getQuery()->getArrayResult();
        return $sliders[0];
    }
    
    public function add($project, $thumb_id, $active) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le projet est ajouté avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = new \Entities\Project();
            $entity->setTitle($project['title']);
            $entity->setActive($active);
            $entity->setPosition($project['position']);
            $entity->setDescription($project['description']);
            $thumb = $em->getRepository('Entities\Resource')->findOneBy(['id' => $thumb_id]);
            $entity->setResource($thumb);
            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    public function update($id, $project, $active, $thumb_id) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le prijet a été modifié avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = $this->find($id);
            $entity->setTitle($project['title']);
            $entity->setActive($active);
            $entity->setPosition($project['position']);
            $entity->setDescription($project['description']);
            if ($thumb_id != null) {
                $image = $em->getRepository('Entities\Resource')->findOneBy(['id' => $entity->getResource()]);
                $em->remove($image);
                unlink($entity->getResource()->getFullPath());
                $thumb = $em->getRepository('Entities\Resource')->findOneBy(['id' => $thumb_id]);
                $entity->setResource($thumb);
            }
            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    public function delete($id, $name) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le projet ' . $name . ' a été supprimé avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $em->remove($this->find($id));
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    public function dumpProject() {
        $em = $this->getEntityManager();
        $projects = [
            [
                'position' => 1,
                'title' => 'Project Title',
                'resource' => [
                    [
                        'name' => 'portfolio-img-1.jpg'
                    ]
                ],
                'active' => true,
                'description' => "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla consequat massa quis enim.",
            ],
            [
                'position' => 2,
                'title' => 'Project Title',
                'resource' => [
                    [
                        'name' => 'portfolio-img-2.jpg'
                    ]
                ],
                'active' => true,
                'description' => "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nulla consequat massa quis enim.",
            ],
        ];
        foreach ($projects as $project) {
            $entity = new \Entities\Project();
            $entity->setTitle($project['title']);
            $entity->setPosition($project['position']);
            $entity->setDescription($project['description']);
            foreach ($project['resource'] as $thumb) {
                $thumbnail = new \Entities\Resource();
                $thumbnail->setName($thumb['name']);
                $em->persist($thumbnail);
                $entity->setResource($thumbnail);
            }
            $entity->setActive($project['active']);
            $em->persist($entity);
            $em->flush();
        }
    }
}