<?php

namespace Repositories;

use Doctrine\ORM\EntityRepository;

/**
 * PartnersRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PartnersRepository extends EntityRepository {

    public function getPartners() {
        $qb = $this->createQueryBuilder('p')
                ->select('p,i')
                ->leftJoin('p.image', 'i');
        return $qb->getQuery()->getArrayResult();
    }

    public function get($id) {

        $qb = $this->createQueryBuilder('par')
                ->select('par,res')
                ->leftJoin('par.image', 'res')
                ->where('par.id = :id')
                ->setParameter('id', $id);
        $patner = $qb->getQuery()->getArrayResult();
        return $patner;
    }
        public function getCountPartner() {
        $qb = $this->createQueryBuilder('n')
                ->select('COUNT(n.id)')
                ->getQuery()
                ->getSingleScalarResult();
        return $qb;
    }

    public function getAllPagination($limit, $start) {
        $qb = $this->createQueryBuilder('p')
                ->select('p,i')
                ->leftJoin('p.image', 'i')
                ->setFirstResult($start)
                ->setMaxResults($limit);
        return $qb->getQuery()->getArrayResult();
    }

    public function add($partner, $thumb_id) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le partenaire est ajouté avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = new \Entities\Partner();
            $entity->setName($partner['name']);
            $entity->setDescription($partner['description']);
            $entity->setWebSite($partner['web_site']);
            $entity->setFacebook($partner['facebook']);
            $entity->setYoutube($partner['youtube']);
            $entity->setTwitter($partner['twitter']);
            $entity->setGplus($partner['gplus']);

            $thumb = $em->getRepository('Entities\Resource')->findOneBy(['id' => $thumb_id]);
            $entity->setImage($thumb);


            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    public function update($id, $partner, $thumb_id) {

        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Un partenaire a été modifiée avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = $this->find($id);
            $entity->setName($partner['name']);
            $entity->setDescription($partner['description']);
            $entity->setWebSite($partner['web_site']);
            $entity->setFacebook($partner['facebook']);
            $entity->setYoutube($partner['youtube']);
            $entity->setTwitter($partner['twitter']);
            $entity->setGplus($partner['gplus']);
            if ($thumb_id != null) {
                $thumb = $em->getRepository('Entities\Resource')->findOneBy(['id' => $thumb_id]);
                $entity->setImage($thumb);
            }
            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    public function delete($id, $name) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> Le partenaire ' . $name . ' a été supprimé avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $em->remove($this->find($id));
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    public function dumpPartner() {
        $entities = $this->findAll();
        if (count($entities) > 0) {
            return false;
        }
        $em = $this->getEntityManager();
        $partners = [
            [

                'image' => [
                    [
                        'name' => '1.jpg'
                    ]
                ],
                'name' => 'par1',
                'description' => '',
                'web_site' => '',
                'facebook' => '',
                'youtube' => '',
                'twitter' => '',
                'gplus' => '',
            ], [

                'image' => [
                    [
                        'name' => '2.jpg'
                    ]
                ],
                'name' => 'par2',
                'description' => '',
                'web_site' => '',
                'facebook' => '',
                'youtube' => '',
                'twitter' => '',
                'gplus' => '',
            ], [

                'image' => [
                    [
                        'name' => '3.jpg'
                    ]
                ],
                'name' => 'par3',
                'description' => '',
                'web_site' => '',
                'facebook' => '',
                'youtube' => '',
                'twitter' => '',
                'gplus' => '',
            ], [

                'image' => [
                    [
                        'name' => '4.jpg'
                    ]
                ],
                'name' => 'par4',
                'description' => '',
                'web_site' => '',
                'facebook' => '',
                'youtube' => '',
                'twitter' => '',
                'gplus' => '',
            ], 
        ];
        foreach ($partners as $partner) {
            $entity = new \Entities\Partner();

            foreach ($partner['image'] as $thumb) {
                $thumbnail = new \Entities\Resource();
                $thumbnail->setName($thumb['name']);
                $em->persist($thumbnail);
                $entity->setImage($thumbnail);
            }
            $entity->setName($partner['name']);
            $entity->setDescription($partner['description']);
            $entity->setWebSite($partner['web_site']);
            $entity->setFacebook($partner['facebook']);
            $entity->setYoutube($partner['youtube']);
            $entity->setTwitter($partner['twitter']);
            $entity->setGplus($partner['gplus']);
            $em->persist($entity);
            $em->flush();
        }
    }

}
