<?php

namespace Repositories;

use Doctrine\ORM\EntityRepository;

/**
 * ExperienceRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ExperienceRepository extends EntityRepository
{
    public function get() {
        $qb = $this->createQueryBuilder('e')
                ->select('e')
                ->orderBy('e.position', 'DESC');
        $experience = $qb->getQuery()->getArrayResult();
        return $experience;
    }
    
    public function getById($id) {
        $qb = $this->createQueryBuilder('e')
                ->select('e')
                ->where('e.id = :id')
                ->setParameter('id', $id);
        $experiences = $qb->getQuery()->getArrayResult();
        return $experiences[0];
    }
    
    public function addExperience($experience) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> L\'expérience a été ajouté avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = new \Entities\Experience();
            $entity->setYears($experience['years']);
            $entity->setDate($experience['date']);
            $entity->setPlace($experience['place']);
            $entity->setPost($experience['post']);
            $entity->setDescription($experience['description']);
            $entity->setPosition($experience['position']);

            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    public function update($id, $experience) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> L\'expérience a été modifiée avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $entity = $this->find($id);

            $entity->setYears($experience['years']);
            $entity->setDate($experience['date']);
            $entity->setPlace($experience['place']);
            $entity->setPost($experience['post']);
            $entity->setDescription($experience['description']);
            $entity->setPosition($experience['position']);
            
            $em->persist($entity);
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }

    
    public function delete($id, $name) {
        $alert = [
            'type' => 'success',
            'msg' => '<strong><i class="fa fa-check"></i></strong> L\'expérience ' . $name . ' a été supprimé avec succès.'
        ];
        $em = $this->getEntityManager();
        $cnx = $em->getConnection();
        $cnx->beginTransaction();
        try {
            $em->remove($this->find($id));
            $em->flush();
            $cnx->commit();
        } catch (Exception $ex) {
            $cnx->rollback();
            $alert = [
                'type' => 'danger',
                'msg' => '<strong><i class="fa fa-warning"></i></strong> Une erreur interne est survenus, veuillez recommancer plutard.'
            ];
        }
        return $alert;
    }
    
    
    protected function add($experience) {
        $em = $this->getEntityManager();
        $entity = new \Entities\Experience();
        
        $entity->setYears($experience['years']);
        $entity->setDate($experience['date']);
        $entity->setPost($experience['post']);
        $entity->setPlace($experience['place']);
        $entity->setDescription($experience['description']);
        $entity->setPosition($experience['position']);

        $em->persist($entity);
        $em->flush();
    }
    
    public function dumpExperience() {

        $experiences = [
            [
                'years' => '2011',
                'date'  => '- Du 01/08/2011 jusqu’à 31/08/2011',
                'post'  => 'Employeur',
                'place' => 'OEP',
                'description' => '- Republique Tunisienne, Ministere de l\'Agriculture, Office de l\'Élevage et des Pâturages.<br>',
                'position' => '1'
            ],
            [
                'years' => '2013',
                'date'  => '- Du 01/07/2013 jusqu’à 31/07/2013',
                'post'  => 'Stagiaire',
                'place' => 'OEP',
                'description' => '- Republique Tunisienne, Ministere de l\'Agriculture, Office de l\'Élevage et des Pâturages.</br>'
                               . "- Création d'un système d'information à l'Office de l'élevage et des pâturages pour faciliter le traçage des différents types d'Élevages.",
                'position' => '2'
            ],
            [
                'years' => '2014',
                'date'  => '- Du 15/12/2013 jusqu’à 15/05/2014',
                'post'  => 'Développeur Web (Projet de Fin d\'Etudes)',
                'place' => 'I PRECISION Tunisie (Boite de développement informatique)',
                'description' => "- Développement d'une application web d’un comparateur de prix des hôtels.",
                'position' => '3'
            ],
            [
                'years' => '2014',
                'date'  => '- Du 15/12/2013 jusqu’à 15/05/2014',
                'post'  => 'Technicien Supérieur en informatique',
                'place' => 'Infenity Multi Service',
                'description' => "- Technicien Supérieur en informatique.",
                'position' => '4'
            ],
            [
                'years' => '2015',
                'date'  => '- Du 01/07/2015 jusqu’à 30/09/2015',
                'post'  => 'Testeur Qualité Logiciel',
                'place' => 'Auxiliance Tunisie (Boite de développement informatique)',
                'description' => "- Effectuer, piloter des tests et vérifier la qualité d'une application web pour le renouvellement des clés d'activation d'antivirus ESET avec les autres acteurs du projet.",
                'position' => '5'
            ],
            [
                'years' => '2015 - 2016',
                'date'  => '- Du 23/10/2015 jusqu’à Aujourd’hui',
                'post'  => 'Développeur Full-Stack',
                'place' => 'Proxima Tunisie (Boite de développement informatique)',
                'description' => '',
                'position' => '6'
            ]
           
        ];
        
        foreach($experiences as $experience) {
            $this->add($experience);
        }
    }
}