<?php

namespace Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entities\User
 */
class User
{
    /**
     * @var integer $id
     */
    protected $id;

    /**
     * @var string $session_id
     */
    protected $session_id;

    /**
     * @var string $first_name
     */
    protected $first_name;

    /**
     * @var string $last_name
     */
    protected $last_name;

    /**
     * @var string $email
     */
    protected $email;

    /**
     * @var string $salt
     */
    protected $salt;

    /**
     * @var string $password
     */
    protected $password;

    /**
     * @var string $token_reset
     */
    protected $token_reset;

    /**
     * @var datetime $token_reset_expire
     */
    protected $token_reset_expire;

    /**
     * @var boolean $active
     */
    protected $active;

    /**
     * @var boolean $admin
     */
    protected $admin;

    /**
     * @var boolean $renew_password
     */
    protected $renew_password;

    /**
     * @var datetime $last_login
     */
    protected $last_login;

    /**
     * @var datetime $created
     */
    protected $created;

    /**
     * @var datetime $updated
     */
    protected $updated;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set session_id
     *
     * @param string $sessionId
     * @return User
     */
    public function setSessionId($sessionId)
    {
        $this->session_id = $sessionId;
        return $this;
    }

    /**
     * Get session_id
     *
     * @return string 
     */
    public function getSessionId()
    {
        return $this->session_id;
    }

    /**
     * Set first_name
     *
     * @param string $firstName
     * @return User
     */
    public function setFirstName($firstName)
    {
        $this->first_name = $firstName;
        return $this;
    }

    /**
     * Get first_name
     *
     * @return string 
     */
    public function getFirstName()
    {
        return $this->first_name;
    }

    /**
     * Set last_name
     *
     * @param string $lastName
     * @return User
     */
    public function setLastName($lastName)
    {
        $this->last_name = $lastName;
        return $this;
    }

    /**
     * Get last_name
     *
     * @return string 
     */
    public function getLastName()
    {
        return $this->last_name;
    }

    /**
     * Set email
     *
     * @param string $email
     * @return User
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * Get email
     *
     * @return string 
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set salt
     *
     * @param string $salt
     * @return User
     */
    public function setSalt($salt)
    {
        $this->salt = $salt;
        return $this;
    }

    /**
     * Get salt
     *
     * @return string 
     */
    public function getSalt()
    {
        return $this->salt;
    }

    /**
     * Set password
     *
     * @param string $password
     * @return User
     */
    public function setPassword($password)
    {
        $this->password = $password;
        return $this;
    }

    /**
     * Get password
     *
     * @return string 
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Set token_reset
     *
     * @param string $tokenReset
     * @return User
     */
    public function setTokenReset($tokenReset)
    {
        $this->token_reset = $tokenReset;
        return $this;
    }

    /**
     * Get token_reset
     *
     * @return string 
     */
    public function getTokenReset()
    {
        return $this->token_reset;
    }

    /**
     * Set token_reset_expire
     *
     * @param datetime $tokenResetExpire
     * @return User
     */
    public function setTokenResetExpire($tokenResetExpire)
    {
        $this->token_reset_expire = $tokenResetExpire;
        return $this;
    }

    /**
     * Get token_reset_expire
     *
     * @return datetime 
     */
    public function getTokenResetExpire()
    {
        return $this->token_reset_expire;
    }

    /**
     * Set active
     *
     * @param boolean $active
     * @return User
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }

    /**
     * Get active
     *
     * @return boolean 
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Set admin
     *
     * @param boolean $admin
     * @return User
     */
    public function setAdmin($admin)
    {
        $this->admin = $admin;
        return $this;
    }

    /**
     * Get admin
     *
     * @return boolean 
     */
    public function getAdmin()
    {
        return $this->admin;
    }

    /**
     * Set renew_password
     *
     * @param boolean $renewPassword
     * @return User
     */
    public function setRenewPassword($renewPassword)
    {
        $this->renew_password = $renewPassword;
        return $this;
    }

    /**
     * Get renew_password
     *
     * @return boolean 
     */
    public function getRenewPassword()
    {
        return $this->renew_password;
    }

    /**
     * Set last_login
     *
     * @param datetime $lastLogin
     * @return User
     */
    public function setLastLogin($lastLogin)
    {
        $this->last_login = $lastLogin;
        return $this;
    }

    /**
     * Get last_login
     *
     * @return datetime 
     */
    public function getLastLogin()
    {
        return $this->last_login;
    }

    /**
     * Set created
     *
     * @param datetime $created
     * @return User
     */
    public function setCreated($created)
    {
        $this->created = $created;
        return $this;
    }

    /**
     * Get created
     *
     * @return datetime 
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @param datetime $updated
     * @return User
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
        return $this;
    }

    /**
     * Get updated
     *
     * @return datetime 
     */
    public function getUpdated()
    {
        return $this->updated;
    }
}