<?php

namespace Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entities\Project
 */
class Project
{
    /**
     * @var integer $id
     */
    protected $id;

    /**
     * @var string $title
     */
    protected $title;

    /**
     * @var boolean $active
     */
    protected $active;

    /**
     * @var integer $position
     */
    protected $position;

    /**
     * @var text $description
     */
    protected $description;

    /**
     * @var Entities\Resource
     */
    protected $resource;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return Project
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * Get title
     *
     * @return string 
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set active
     *
     * @param boolean $active
     * @return Project
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }

    /**
     * Get active
     *
     * @return boolean 
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Set position
     *
     * @param integer $position
     * @return Project
     */
    public function setPosition($position)
    {
        $this->position = $position;
        return $this;
    }

    /**
     * Get position
     *
     * @return integer 
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * Set description
     *
     * @param text $description
     * @return Project
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * Get description
     *
     * @return text 
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set resource
     *
     * @param Entities\Resource $resource
     * @return Project
     */
    public function setResource(\Entities\Resource $resource = null)
    {
        $this->resource = $resource;
        return $this;
    }

    /**
     * Get resource
     *
     * @return Entities\Resource 
     */
    public function getResource()
    {
        return $this->resource;
    }
}