<?php

namespace Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entities\Experience
 */
class Experience
{
    /**
     * @var integer $id
     */
    protected $id;

    /**
     * @var string $years
     */
    protected $years;

    /**
     * @var string $post
     */
    protected $post;

    /**
     * @var string $title
     */
    protected $title;

    /**
     * @var text $description
     */
    protected $description;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set years
     *
     * @param string $years
     * @return Experience
     */
    public function setYears($years)
    {
        $this->years = $years;
        return $this;
    }

    /**
     * Get years
     *
     * @return string 
     */
    public function getYears()
    {
        return $this->years;
    }

    /**
     * Set post
     *
     * @param string $post
     * @return Experience
     */
    public function setPost($post)
    {
        $this->post = $post;
        return $this;
    }

    /**
     * Get post
     *
     * @return string 
     */
    public function getPost()
    {
        return $this->post;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return Experience
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * Get title
     *
     * @return string 
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set description
     *
     * @param text $description
     * @return Experience
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }

    /**
     * Get description
     *
     * @return text 
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * @var integer $position
     */
    protected $position;


    /**
     * Set position
     *
     * @param integer $position
     * @return Experience
     */
    public function setPosition($position)
    {
        $this->position = $position;
        return $this;
    }

    /**
     * Get position
     *
     * @return integer 
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * @var string $place
     */
    protected $place;


    /**
     * Set place
     *
     * @param string $place
     * @return Experience
     */
    public function setPlace($place)
    {
        $this->place = $place;
        return $this;
    }

    /**
     * Get place
     *
     * @return string 
     */
    public function getPlace()
    {
        return $this->place;
    }
    /**
     * @var string $date
     */
    protected $date;


    /**
     * Set date
     *
     * @param string $date
     * @return Experience
     */
    public function setDate($date)
    {
        $this->date = $date;
        return $this;
    }

    /**
     * Get date
     *
     * @return string 
     */
    public function getDate()
    {
        return $this->date;
    }
}