<?php

namespace Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entities\AlbumResource
 */
class AlbumResource
{
    /**
     * @var integer $id
     */
    protected $id;

    /**
     * @var boolean $is_thumb
     */
    protected $is_thumb;

    /**
     * @var Entities\Album
     */
    protected $album;

    /**
     * @var Entities\Resource
     */
    protected $resource;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set is_thumb
     *
     * @param boolean $isThumb
     * @return AlbumResource
     */
    public function setIsThumb($isThumb)
    {
        $this->is_thumb = $isThumb;
        return $this;
    }

    /**
     * Get is_thumb
     *
     * @return boolean 
     */
    public function getIsThumb()
    {
        return $this->is_thumb;
    }

    /**
     * Set album
     *
     * @param Entities\Album $album
     * @return AlbumResource
     */
    public function setAlbum(\Entities\Album $album = null)
    {
        $this->album = $album;
        return $this;
    }

    /**
     * Get album
     *
     * @return Entities\Album 
     */
    public function getAlbum()
    {
        return $this->album;
    }

    /**
     * Set resource
     *
     * @param Entities\Resource $resource
     * @return AlbumResource
     */
    public function setResource(\Entities\Resource $resource = null)
    {
        $this->resource = $resource;
        return $this;
    }

    /**
     * Get resource
     *
     * @return Entities\Resource 
     */
    public function getResource()
    {
        return $this->resource;
    }
}