<?php

namespace Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * Entities\Album
 */
class Album
{
    /**
     * @var integer $id
     */
    protected $id;

    /**
     * @var string $title
     */
    protected $title;

    /**
     * @var text $descritption
     */
    protected $descritption;

    /**
     * @var Entities\Galerie
     */
    protected $galerie;

    /**
     * @var \Doctrine\Common\Collections\ArrayCollection
     */
    protected $album_resources;

    public function __construct()
    {
        $this->album_resources = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return Album
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * Get title
     *
     * @return string 
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set descritption
     *
     * @param text $descritption
     * @return Album
     */
    public function setDescritption($descritption)
    {
        $this->descritption = $descritption;
        return $this;
    }

    /**
     * Get descritption
     *
     * @return text 
     */
    public function getDescritption()
    {
        return $this->descritption;
    }

    /**
     * Set galerie
     *
     * @param Entities\Galerie $galerie
     * @return Album
     */
    public function setGalerie(\Entities\Galerie $galerie = null)
    {
        $this->galerie = $galerie;
        return $this;
    }

    /**
     * Get galerie
     *
     * @return Entities\Galerie 
     */
    public function getGalerie()
    {
        return $this->galerie;
    }

    /**
     * Add album_resources
     *
     * @param Entities\AlbumResource $albumResources
     * @return Album
     */
    public function addAlbumResource(\Entities\AlbumResource $albumResources)
    {
        $this->album_resources[] = $albumResources;
        return $this;
    }

    /**
     * Get album_resources
     *
     * @return Doctrine\Common\Collections\Collection 
     */
    public function getAlbumResources()
    {
        return $this->album_resources;
    }
}