<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

// ------------------------------------------------------------------------
// URL HELPERS


/**
 * Get common asset URL
 *
 * @access public
 * @return string
 */
if (!function_exists('common_url')) {

    function common_url() {
        //get an instance of CI so we can access our configuration
        $CI = & get_instance();
        //return the full asset path
        return base_url() . $CI->config->item('common_path') . DIRECTORY_SEPARATOR;
    }

}

/**
 * Get vendors asset URL
 *
 * @access public
 * @return string
 */
if (!function_exists('vendors_url')) {

    function vendors_url() {
        //get an instance of CI so we can access our configuration
        $CI = & get_instance();
        //return the full asset path
        return base_url() . $CI->config->item('vendors_path') . DIRECTORY_SEPARATOR;
    }

}

/**
 * Get theme URL
 *
 * @access public
 * @return string
 */
if (!function_exists('theme_url')) {

    function theme_url() {
        //get an instance of CI so we can access our configuration
        $CI = & get_instance();
        //return the full theme path
        return base_url() . $CI->config->item('theme_path') . DIRECTORY_SEPARATOR;
    }

}

/**
 * Get theme URL
 *
 * @access public
 * @return string
 */
if (!function_exists('common_path')) {

    function common_path() {
        //get an instance of CI so we can access our configuration
        $CI = & get_instance();
        //return the full theme path
        return base_url() . $CI->config->item('common_path') . DIRECTORY_SEPARATOR;
    }

}
/**
 * Get css URL
 *
 * @access public
 * @return string
 */
if (!function_exists('css_url')) {

    function css_url() {
        $CI = & get_instance();
        return base_url() . $CI->config->item('css_path') . DIRECTORY_SEPARATOR;
    }

}

/**
 * Get js URL
 *
 * @access public
 * @return string
 */
if (!function_exists('js_url')) {

    function js_url() {
        $CI = & get_instance();
        return base_url() . $CI->config->item('js_path') . DIRECTORY_SEPARATOR;
    }

}

/**
 * Get image URL
 *
 * @access public
 * @return string
 */
if (!function_exists('images_url')) {

    function images_url() {
        $CI = & get_instance();
        return base_url() . $CI->config->item('images_path') . DIRECTORY_SEPARATOR;
    }

}

/**
 * Get Upload URL
 *
 * @access public
 * @return string
 */
if (!function_exists('upload_url')) {
    function upload_url() {
        $CI = & get_instance();
        return base_url() . $CI->config->item('upload_path') . DIRECTORY_SEPARATOR;
    }
}

/**
* Get the Absolute Upload Path
*
* @access public
* @return string
*/
if ( ! function_exists('upload_path'))
{
    function upload_path()
    {
        $CI =& get_instance();
        return FCPATH . $CI->config->item('upload_path');
    }
}

/* End of file asset_helper.php */