<?php

namespace GestionBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * VersionRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class VersionRepository extends EntityRepository
{
    public function getAllVersionComposant() {
        $qb = $this->createQueryBuilder('v')
                ->select('v, c')
                ->leftJoin('v.comp', 'c')
                ->where('v.comp is not null')
                ->getQuery();
        return $qb->getArrayResult();
    }
    
    public function getAllVersionProduit() {
        $qb = $this->createQueryBuilder('v')
                ->select('v, p')
                ->leftJoin('v.prod', 'p')
                ->where('v.prod is not null')
                ->getQuery();
        return $qb->getArrayResult();
    }
    
    public function getAllVersionByComposant($composant) {
        $qb = $this->createQueryBuilder('v')
                ->select('v.version')
                ->where('v.comp = :id')
                ->setParameter('id', $composant)
                ->getQuery();
        return $qb->getResult();
    }
    
    public function getAllVersionByProduit($produit) {
        $qb = $this->createQueryBuilder('v')
                ->select('v.version')
                ->where('v.prod = :id')
                ->setParameter('id', $produit)
                ->getQuery();
        return $qb->getResult();
    }
}
