<?php

namespace GestionBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use GestionBundle\Form\VersionType;

class ProduitType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
                ->add('titre')
                ->add('client')
                ->add('etat', 'choice', array(
                    'label' => 'État',
                    'label_attr' => [
                        'class' => ''
                    ],
                    'choices' => array(
                        '' => '-- État -- ',
                        'en cours' => 'en cours',
                        'en maintenance' => 'en maintenance',
                    ),
                    'attr' => [
                        
                    ]
                ))
                ->add('version', new VersionType())  
                ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'GestionBundle\Entity\Produit'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'gestionbundle_produit';
    }


}
