<?php

namespace GestionBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Version
 */
class Version
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var string
     */
    private $version;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $composant;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->composant = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set version
     *
     * @param string $version
     * @return Version
     */
    public function setVersion($version)
    {
        $this->version = $version;

        return $this;
    }

    /**
     * Get version
     *
     * @return string 
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * Add composant
     *
     * @param \GestionBundle\Entity\Composant $composant
     * @return Version
     */
    public function addComposant(\GestionBundle\Entity\Composant $composant)
    {
        $this->composant[] = $composant;

        return $this;
    }

    /**
     * Remove composant
     *
     * @param \GestionBundle\Entity\Composant $composant
     */
    public function removeComposant(\GestionBundle\Entity\Composant $composant)
    {
        $this->composant->removeElement($composant);
    }

    /**
     * Get composant
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getComposant()
    {
        return $this->composant;
    }
    /**
     * @var \GestionBundle\Entity\Composant
     */
    private $comp;


    /**
     * Set comp
     *
     * @param \GestionBundle\Entity\Composant $comp
     * @return Version
     */
    public function setComp(\GestionBundle\Entity\Composant $comp = null)
    {
        $this->comp = $comp;

        return $this;
    }

    /**
     * Get comp
     *
     * @return \GestionBundle\Entity\Composant 
     */
    public function getComp()
    {
        return $this->comp;
    }
    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $produit;


    /**
     * Add produit
     *
     * @param \GestionBundle\Entity\Produit $produit
     * @return Version
     */
    public function addProduit(\GestionBundle\Entity\Produit $produit)
    {
        $this->produit[] = $produit;

        return $this;
    }

    /**
     * Remove produit
     *
     * @param \GestionBundle\Entity\Produit $produit
     */
    public function removeProduit(\GestionBundle\Entity\Produit $produit)
    {
        $this->produit->removeElement($produit);
    }

    /**
     * Get produit
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getProduit()
    {
        return $this->produit;
    }
    /**
     * @var \GestionBundle\Entity\Produit
     */
    private $prod;


    /**
     * Set prod
     *
     * @param \GestionBundle\Entity\Produit $prod
     * @return Version
     */
    public function setProd(\GestionBundle\Entity\Produit $prod = null)
    {
        $this->prod = $prod;

        return $this;
    }

    /**
     * Get prod
     *
     * @return \GestionBundle\Entity\Produit 
     */
    public function getProd()
    {
        return $this->prod;
    }
}
