<?php

namespace GestionBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Produit
 */
class Produit
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var string
     */
    private $titre;

    /**
     * @var string
     */
    private $client;

    /**
     * @var string
     */
    private $etat;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $vr;

    /**
     * @var \GestionBundle\Entity\Version
     */
    private $version;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->vr = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set titre
     *
     * @param string $titre
     * @return Produit
     */
    public function setTitre($titre)
    {
        $this->titre = $titre;

        return $this;
    }

    /**
     * Get titre
     *
     * @return string 
     */
    public function getTitre()
    {
        return $this->titre;
    }

    /**
     * Set client
     *
     * @param string $client
     * @return Produit
     */
    public function setClient($client)
    {
        $this->client = $client;

        return $this;
    }

    /**
     * Get client
     *
     * @return string 
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * Set etat
     *
     * @param string $etat
     * @return Produit
     */
    public function setEtat($etat)
    {
        $this->etat = $etat;

        return $this;
    }

    /**
     * Get etat
     *
     * @return string 
     */
    public function getEtat()
    {
        return $this->etat;
    }

    /**
     * Add vr
     *
     * @param \GestionBundle\Entity\Version $vr
     * @return Produit
     */
    public function addVr(\GestionBundle\Entity\Version $vr)
    {
        $this->vr[] = $vr;

        return $this;
    }

    /**
     * Remove vr
     *
     * @param \GestionBundle\Entity\Version $vr
     */
    public function removeVr(\GestionBundle\Entity\Version $vr)
    {
        $this->vr->removeElement($vr);
    }

    /**
     * Get vr
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getVr()
    {
        return $this->vr;
    }

    /**
     * Set version
     *
     * @param \GestionBundle\Entity\Version $version
     * @return Produit
     */
    public function setVersion(\GestionBundle\Entity\Version $version = null)
    {
        $this->version = $version;

        return $this;
    }

    /**
     * Get version
     *
     * @return \GestionBundle\Entity\Version 
     */
    public function getVersion()
    {
        return $this->version;
    }
}
