<?php

namespace GestionBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class AdminController extends Controller
{
    public function indexAction()
    {
        if (! $this->get('security.authorization_checker')->isGranted('ROLE_ADMIN')) {
            return $this->redirectToRoute('responsable_homepage');
        }
        return $this->render('GestionBundle:Admin:index.html.twig');
    }
    
    public function usersAction()
    {
        $em = $this->getDoctrine()->getManager();
        $entities = $em->getRepository('UserBundle:User')->findAll();
        return $this->render('GestionBundle:Default:users.html.twig', array(
                    'entities' => $entities,
        ));
    }
   
}
